//----------------------------------------------------------------------------//
//- CapBaseReport.pas --------------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Quickreport von dem die meisten anderen Quickreports abgeleitet werden     //
// es wird sollte keine Instanz dieser Klasse erzeugt werden.                 //
//----------------------------------------------------------------------------//

unit CapBaseReport;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses Windows, SysUtils, Messages, Classes, Graphics, Controls, StdCtrls,
     ExtCtrls, Forms, QuickRpt, QRCtrls, CaoBoersenInfo, CaoFormat;

//------------------------------------------------------------------------------

type
  TCaQrpBaseReport = class(TQuickRep)
    m_BndKopfzeile  : TQRBand;
    m_QrLblTitel    : TQRLabel;
    m_BndFusszeile  : TQRBand;
    m_QrLblDatum    : TQRLabel;

    //--------------------------------------------------------------------------

    procedure QuickRepBeforePrint (Sender         : TCustomQuickRep;
                                   var PrintReport: Boolean);
    procedure QuickRepAfterPrint  (Sender: TObject);

  //----------------------------------------------------------------------------

  private

  //----------------------------------------------------------------------------

  protected
    m_obBoersenInfo: TCaoBoersenInfo;
    m_obFormat     : TCaoFormat; 

    //--------------------------------------------------------------------------

    procedure PrtSetHeader; virtual;
    procedure PrtSetFooter; virtual;

  //----------------------------------------------------------------------------

  public
    procedure Preview(obBoersenInfo: TCaoBoersenInfo); 
    procedure Print  (obBoersenInfo: TCaoBoersenInfo);


  //----------------------------------------------------------------------------

  end; // TCaQrpBaseReport

//------------------------------------------------------------------------------

var
  CaQrpBaseReport: TCaQrpBaseReport;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.DFM}

//------------------------------------------------------------------------------

procedure TCaQrpBaseReport.Preview(obBoersenInfo: TCaoBoersenInfo);
begin
  // Zum Abfllen der Kopfzeile werden die Brsendaten bentigt
  m_obBoersenInfo := obBoersenInfo;
  inherited Preview;
end; // TCaQrpBaseReport.Preview

//------------------------------------------------------------------------------

procedure TCaQrpBaseReport.Print(obBoersenInfo: TCaoBoersenInfo);
begin
  // Zum Abfllen der Kopfzeile werden die Brsendaten bentigt
  m_obBoersenInfo := obBoersenInfo;
  inherited Print;
end; // TCaQrpBaseReport.Print

//------------------------------------------------------------------------------

procedure TCaQrpBaseReport.PrtSetFooter;
(*
  Abfllen der Fusszeile
*)
begin
  m_QrLblDatum.Caption := DateTimeToStr(Now);
end; // TCaQrpBaseReport.PrtSetFooter

//------------------------------------------------------------------------------

procedure TCaQrpBaseReport.PrtSetHeader;
(*
  Abfllen der Kopfzeile
*)
begin
  m_QrLblTitel.Caption := m_obBoersenInfo.sTitel; 
end; // TCaQrpBaseReport.PrtSetHeader

//------------------------------------------------------------------------------

procedure TCaQrpBaseReport.QuickRepBeforePrint(Sender         : TCustomQuickRep;
                                               var PrintReport: Boolean);
begin
  m_obFormat := TCaoFormat.Create;
  // Setzen der Kopf- und Fusszeile
  PrtSetHeader;
  PrtSetFooter;
end; // TCaQrpBaseReport.QuickRepBeforePrint

//------------------------------------------------------------------------------

procedure TCaQrpBaseReport.QuickRepAfterPrint(Sender: TObject);
begin
  m_obFormat.Free;
end; // TCaQrpBaseReport.QuickRepAfterPrint

//------------------------------------------------------------------------------

end. // CapBaseReport
